<?xml version="1.0" encoding="utf-8"?>

<!-- adaptation des chemins internes d'un doc html -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >
	<xsl:output method="html" />
	<xsl:param name="path" />

	<xsl:template match="/">
		<h3>adaptHTMLurl</h3>
  		<xsl:call-template name="update-path">
			<xsl:with-param name="currentnode" select="."/>
		</xsl:call-template>	
      </xsl:template>

	<!-- sous-template pour chercher les attributs src -->
	<xsl:template name="update-path" >
		<xsl:param name="currentnode"/>
		<xsl:for-each select="*">
			<xsl:variable name="subnode" select="."/>
			<h3>Un noeud a été trouvé : <xsl:value-of select="name()"/></h3>
			
			<xsl:choose>
				<xsl:when test="name()='img'">
					<h4>et c'est une image !</h4>
					<xsl:element name="img">
					<xsl:for-each select="@*">
						<xsl:choose>
							<xsl:when test="name()='src'">
								<xsl:attribute name="{name()}">
									<xsl:value-of select="concat($path, .)"/>
								</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{name()}">
									<xsl:value-of select="." />
								</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					</xsl:element>
				</xsl:when>
				<!-- le noeud a-t-il des fils ?-->
				<xsl:when test="*">
					<h4>il a des descendants : <xsl:value-of select="count(*)"/></h4>
					<xsl:element name="{name($subnode)}">
						<xsl:for-each select="$subnode/@*">
							<xsl:attribute name="{name()}">
								<xsl:value-of select="." />
							</xsl:attribute>
						</xsl:for-each>
						<xsl:call-template name="update-path">
							<xsl:with-param name="currentnode" select="$subnode"/>
						</xsl:call-template>
					</xsl:element>
				</xsl:when>	
				<!-- si c'est une feuille on le recopie -->	
				<xsl:otherwise>
					<h4>il n'a pas de descendants.</h4>
					<xsl:copy-of select="."/>
				</xsl:otherwise>	
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>	
</xsl:stylesheet>
  